/*
 The Techlabs Pure MVC Tutorial
 Copyright (c) 2009 Pedro Furtado (pedro.furtado@gmail.com)
 Your reuse is governed by the Creative Commons Attribution 3.0 License
*/
package com.techlabs.puremvc
{
    import com.techlabs.puremvc.controller.AddFeedCommand;
    import com.techlabs.puremvc.controller.ApplicationStartupCommand;
    import com.techlabs.puremvc.controller.RemoveFeedCommand;
    
    import org.puremvc.as3.interfaces.*;
    import org.puremvc.as3.patterns.facade.*;
    import org.puremvc.as3.patterns.proxy.*;

    /**
     *
     */
    public class ApplicationFacade extends Facade
    {
        // Notification name constants
		// application
        public static const STARTUP:String 					= "startup";
        public static const SHUTDOWN:String 				= "shutdown";

		
		// proxy
        public static const LOADING_STEP:String				= "loadingStep";
        public static const LOADING_COMPLETE:String			= "loadingComplete";
        public static const LOADING_FEED_COMPLETE:String	= "loadingFeedComplete";
		public static const LOAD_CONFIG_FAILED:String		= "loadConfigFailed";
        public static const LOAD_RESOURCE_FAILED:String		= "loadResourceFailed";
		
		// command
        public static const COMMAND_STARTUP_MONITOR:String	= "StartupMonitorCommand";
        public static const FEED_ADDED:String				= "feedAdded";
		public static const REMOVE_FEED:String				= "removeFeed";
		
		// view
		public static const VIEW_ADD_FEED:String			= "viewAddFeed";
		public static const VIEW_MAIN_SCREEN:String			= "viewMainScreen";
		
		// common messages
		public static const ERROR_LOAD_FILE:String			= "Could Not Load the File!";
		
        /**
         * Singleton ApplicationFacade Factory Method
         */
        public static function getInstance() : ApplicationFacade 
		{
            if ( instance == null ) 
            	instance = new ApplicationFacade( );
            return instance as ApplicationFacade;
        }

        /**
         * Register Commands with the Controller 
         */
        override protected function initializeController( ) : void 
        {
            super.initializeController(); 
            registerCommand( STARTUP, ApplicationStartupCommand );
            registerCommand( FEED_ADDED, AddFeedCommand );
            registerCommand( REMOVE_FEED, RemoveFeedCommand );
        }
		
		/**
		 * Start the application
		 */
		public function startup( app:TheTechLabsRssReader ):void
		{
			sendNotification( STARTUP, app );
		}
		
    }
}